/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Address Object,     *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Address Object will not function without a valid           *
#*      			  license string 			          	   *
#************************************************************* */

set pagesize 50000;
set long 20000;
set echo off;
set pages 999;
set serveroutput on;

truncate table log;
commit;

declare
  ao pls_integer;
  bno varchar2(100);
  val varchar2(32767);
  ok integer;
counter integer := 0;
  i number := 0;
   err_num NUMBER;
   err_msg VARCHAR2(100);

begin

  ao := mdAddrCreate();
  insert into log values('created mdAddr object');
  commit;

  ok := mdAddrSetLicenseString(ao, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdAddrGetBuildNumber(ao);
  insert into log values('build number= ' || bno);
  commit;

  mdAddrSetPathToUSFiles(ao, 'SET_PATH_HERE');
  insert into log values('set path to US files');
  commit;

  
  /*mdAddrSetPathToDPVDataFiles(ao, 'SET_PATH_HERE');
  insert into log values('set path to DPV files');
  commit;

  mdAddrSetPathToCanadaFiles(ao, 'SET_PATH_HERE');
  insert into log values('set path to Canada files');
  commit;

  mdAddrSetPathToLLKDataFiles (ao, 'SET_PATH_HERE');
  insert into log values('set path to LACS files');
  commit;  

  mdAddrSetPathToSLKDataFiles(ao, 'SET_PATH_HERE');
  insert into log values('set path to SUITE LINK files');
  commit;

  mdAddrSetPathToSFNDDataFiles (ao, 'SET_PATH_HERE');
  insert into log values('set path to SUITE FINDER files');
  commit;


  mdAddrSetPathToRBDIFiles (ao, 'SET_PATH_HERE');*/
  insert into log values('set path to RBDI files');
  commit;

  ok := mdAddrInitializeDataFiles(ao);
  insert into log values('init datafiles: error=' || ok);
  commit;

  val := mdAddrGetInitializeErrorString(ao);
  insert into log values('init error string = ' || val);
  commit;

  val := mdAddrGetDatabaseDate(ao);
  insert into log values('database date = ' || val);
  commit;

  val := mdAddrGetExpirationDate(ao);
  
  insert into log values('exp date = ' || val);
  commit;

  for rec in (select * from md_apne_table) loop
  BEGIN
    mdAddrClearProperties(ao);
    mdAddrSetAddress(ao, NVL(rec.ADDRESS1,' '));
    mdAddrSetZip(ao, NVL(rec.ZIP,' '));
    ok := mdAddrVerifyAddress(ao);
    val := (mdAddrGetResults(ao) || ' ' || mdAddrGetZip(ao) || '-' || mdAddrGetPlus4(ao) || ' ' || rec.ADDRESS1 || ' ' || rec.CITY);
    DBMS_OUTPUT.PUT_LINE(val);
    DBMS_OUTPUT.PUT_LINE(counter);
    counter := counter + 1;
    EXCEPTION
     WHEN OTHERS THEN
	err_num := SQLCODE;
	err_msg := SUBSTR(SQLERRM, 1, 100);
	insert into log values('ORA' || err_num || ': ' || err_msg);
	insert into log values(val);
	commit;
	exit;
    END;
  end loop;

  if err_num != -28576
  then
    mdAddrDestroy(ao);
    insert into log values('destroyed mdAddr object');
    commit;
  end if;

end;
/


